<?php /* Template Name: Case study */ 
function add_css_in_head(){
    wp_register_style('case', get_template_directory_uri() . '/css/case-study.css', array(), '1.0', 'all');
    wp_enqueue_style('case'); // Enqueue it! 

}
add_action('wp_head','add_css_in_head');

get_header(); ?>

	<main role="main" class="main-interne">
    	<section class="section-top" style="background: url(<?php the_post_thumbnail_url(); ?>) no-repeat center; background-size: cover;">
            <div class="content-top-banner">
            	<div class="width-content-1580">
	    			<div class="container-fluid">
	    				<div class="row">
	    					<div class="col-lg-6 offset-lg-1">
	    						<div class="content-banner">
	    							<h1><?php the_title(); ?></h1>
                                    <p><?php the_content(); ?></p>
	    						</div>
	    					</div>
                            <div class="col-lg-4">
                                <div class="content-logo-banner">
                                    <div class="content-logo">
                                    	<?php if(get_field('logo_grand')) : ?>
                                        <img src="<?php echo get_field('logo_grand')['url']; ?>" alt="ico" />      
                                        <?php endif; ?>                    
                                    </div>
                                </div>
                            </div>
	    				</div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section-contexte">
            <div class="width-content-1580">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-4 offset-lg-1">
    						<h2><?php the_field('section_contexte_libelle'); ?></h2>
    						<?php the_field('section_contexte_texte'); ?>
                        </div>
                        <div class="col-lg-5 offset-lg-1">
                            <div class="content-image">
                            	<?php if(get_field('section_contexte_image')) : ?>
                                <img src="<?php echo get_field('section_contexte_image')['url']; ?>" alt="ico" />      
                                <?php endif; ?>    
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>

        <section class="section-probleme section__exp">
            <div class="width-content-1580">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1 text-center">
                            <hr>
    						<h2><?php the_field('section_probleme_titre'); ?></h2>
    						<?php the_field('section_probleme_texte'); ?>

                            <hr class="hr-2ps">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section-solution">
            <div class="width-content-1580">
                <div class="container-fluid">
                    <div class="row row-title-solution">
                        <div class="col-lg-8 offset-lg-2">
                            <h2><?php the_field('section_solution_titre'); ?></h2>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="container-fluid">
                                <div class="row row-solution">
                                    <div class="col-lg-6 offset-lg-1">
			    						<?php the_field('section_solution_texte'); ?>
                                    </div>
                                    <div class="col-lg-4">
		                            	<?php if(get_field('section_solution_image')) : ?>
		                                <img src="<?php echo get_field('section_solution_image')['url']; ?>" alt="ico" />      
		                                <?php endif; ?>  
                                    </div>
                                    <div class="col-lg-8 offset-lg-1 col-solution-2">
			    						<?php the_field('section_solution_texte_2'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php if(get_field('section_temoignage_contenu')): ?>
        <section class="section-temoignage">
            <div class="width-content-1580">
                <div class="container-fluid">
                    <div class="row row-title-temoignage">
                        <div class="col-lg-10 offset-lg-1">
                            <h2><?php the_field('section_temoignage_titre'); ?></h2>
                        </div>
                    </div>
                    <div class="row row-content-temoignage">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="container-fluid">
                                <div><?php the_field('section_temoignage_contenu'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>

	</main>

<?php get_footer(); ?>
