<?php /* Template Name: Vision née de l'experience */ 
function add_css_in_head(){
    wp_register_style('vision-experience', get_template_directory_uri() . '/css/vision-experience.css', array(), '1.0', 'all');
    wp_enqueue_style('vision-experience'); // Enqueue it! 
}
add_action('wp_head','add_css_in_head');
get_header(); ?>

	<main class="main-interne">
		


    	<section class="section-top text-center">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
    						<h1><?php the_field("grand_titre"); ?></h1>
                            <?php the_content(); ?>
    					</div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section-timeline">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12 text-center">
                            <h2><?php the_field('section_1_titre'); ?></h2>
                        </div>
                    </div>




                    <?php if( have_rows('section_1_liste') ): $first_row = true; ?>
                        <?php while(have_rows('section_1_liste') ): the_row(); 

                        // vars
                        $image = get_sub_field('image');
                        $content = get_sub_field('texte');
                        $annee = get_sub_field('annee');
                        ?>


                        <div class="row <?php if($first_row == true) : echo 'first-row'; endif; ?>">
                            <div class="col-md-4">
                                <div class="content-text">
                                    <?php echo $content; ?>
                                </div>
                            </div>
                            <div class="col-md-4 col-year">
                                <div class="content-time  text-center">
                                    <p class="year-time"><?php echo $annee; ?></p>
                                    <div class="round"></div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="content-img">                                    
                                    <img src="<?php echo $image['url']; ?>" alt="time">
                                </div>
                            </div>
                        </div>
                        <?php $first_row = false; endwhile;  ?>
                    <?php endif; ?>


    			</div>
    		</div>
		</section>

    	<section class="section__exp">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
                            <hr />
    						<div class="content_ text-center">
                                <?php the_field("section_2_paragraphe"); ?>
    						</div>
                            <div class="content-img text-center">
                                <?php if(get_field('section_2_image')) : ?>
                                    <img src="<?php echo get_field('section_2_image')['url']; ?>" alt="time" />      
                                <?php endif; ?>  
                            </div>
    					</div>
                    </div>
                    <div class="row row-percent">
                        <div class="col-lg-12">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="percent"><?php the_field("section_2_texte_gauche"); ?></div>
                                    </div>
                                    <div class="col-lg-8">
                                        <?php the_field("section_2_texte_droite"); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>

	</main>

<?php get_footer(); ?>
