<?php /* Template Name: Studies */ 
function add_css_in_head(){
    wp_register_style('studies', get_template_directory_uri() . '/css/studies.css', array(), '1.0', 'all');
    wp_enqueue_style('studies'); // Enqueue it! 



}
add_action('wp_head','add_css_in_head');

get_header(); ?>

	<main role="main">


        <section class="section-top "  style="background: url(<?php the_post_thumbnail_url(); ?>) no-repeat center; background-size: inherit !important;">
            <div class="content-top-banner">
                <div class="width-content-1580">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-12">
                                <h1><?php the_title(); ?></h1>
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="section-case-studies"  style="">
            <div class="content-top-banner">
                <div class="width-content-1580">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-xl-10 offset-xl-1">
                                <div class="list-case" >

                                    <?php   
                                        $loop = new WP_Query( array( 'post_type' => 'studie' ) );
                                        if($loop){ $i= 1;
                                            while ( $loop->have_posts() ) : $loop->the_post();
                                    ?>
                                        <div class="item" data-hash="studies-<?php echo $i; ?>"  style="background: url(<?php echo get_field('image')['url']; ?>) no-repeat center;">
                                            <div class="content-case">
                                                <div class="d-flex content-title-case">
                                                <h3><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></h3>
                                                <div class=logo-case><a href="<?php the_permalink(); ?>"><img src="<?php echo get_field('logo')['url']; ?>" alt="ico" /></a></div>
                                                </div>
                                                <a href="<?php the_permalink(); ?>"><?php the_excerpt(); ?></a>
                                            </div>
                                        </div>
                                    <?php $i++;
                                            endwhile;
                                        }
                                        wp_reset_query();
                                    ?>

                                </div>

                                <div class="case-hash list-hash">


                                    <?php   
                                        $loop = new WP_Query( array( 'post_type' => 'studie' ) );
                                        if($loop){ $i= 1;
                                            while ( $loop->have_posts() ) : $loop->the_post();
                                    ?>
                                         <a href="<?php the_permalink(); ?>">
                                            <span class="logo-case"><img src="<?php echo get_field('logo')['url']; ?>" alt="ico" /></span>
                                            <span class="text-hash"><?php the_title(); ?></span>
                                        </a> 

                                    <?php $i++;
                                            endwhile;
                                        }
                                        wp_reset_query();
                                    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

	</main>

<?php get_footer(); ?>
