<?php /* Template Name: Solutions */ 
function add_css_in_head(){
    wp_register_style('solution', get_template_directory_uri() . '/css/solution.css', array(), '1.0', 'all');
    wp_enqueue_style('solution'); // Enqueue it! 
}
add_action('wp_head','add_css_in_head');
get_header(); ?>

	<main class="main-interne">
		


    	<section class="section-top">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-5 offset-lg-1">
    						<div class="content-txt-top">
                                <h1><?php the_field("titre"); ?></h1>
                                <?php the_field("contenu"); ?>
                            </div>
    					</div>
                        <div class="col-lg-6">
                            <div class="content-img">

                                <?php if(get_field('image_avion')) : ?>
                                    <img src="<?php echo get_field('image_avion')['url']; ?>" alt="plane" />      
                                <?php endif; ?>  
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section__">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">



                        <?php if( have_rows('section_1_pictogramme_liste') ): ?>
                            <?php while(have_rows('section_1_pictogramme_liste') ): the_row(); 

                            // vars
                            $image = get_sub_field('pictogramme');
                            $content = get_sub_field('texte');
                            ?>

                            <div class="col-lg-6 text-center">
                                <div class="item-picto">
                                    <div class="content-picto">
                                        <img src="<?php echo $image['url']; ?>" alt="Picto">
                                    </div>
                                    <?php echo $content; ?>
                                </div>
                            </div>
                            <?php endwhile;  ?>
                        <?php endif; ?>



                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="content-text-round">
                                <?php the_field("section_2_texte");?>
                            </div>
                        </div>
                        <div class="col-lg-6 text-center">
                            <div class="round-picto content-picto">
                                <?php if(get_field('section_2_image')) : ?>
                                    <img src="<?php echo get_field('section_2_image')['url']; ?>" alt="<?php echo get_field('section_2_image')['alt']; ?>" />
                                <?php endif; ?>  
                                <!-- img src="<?php echo get_template_directory_uri(); ?>/img/temp/solutions/picto1.png" alt="time" -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
    						<div class="content-text content-txt-light"> 
                                <hr>
                                <?php the_field('section_3_texte'); ?>
                                <hr>
    						</div>
    					</div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section__ section-percent-2">
            <div class="width-content">
    			<div class="container-fluid">
                    <div class="row row-percent">
                        <div class="col-lg-12">
                            <div class="container-fluid">
                                <div class="row">
                                    <?php if(get_field("section_4_titre")) : ?>
                                        <div class="col-lg-12">
                                            <h2 class="title-light"><?php the_field("section_4_titre"); ?></h2>
                                        </div>
                                    <?php endif; ?>  
                                    <div class="col-lg-4">
                                        <div class="percent"><?php the_field("section_4_chiffre"); ?></div>
                                        <div class="label-percent"><p><?php the_field("section_4_chiffre_label"); ?></p></div>
                                    </div>
                                    <div class="col-lg-8">
                                        <?php the_field("section_4_texte"); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
    				</div>
                    <div class="row">
                         <div class="col-lg-12">
                                <?php if(get_field('section_4_image')) : ?>
                                <div class="content-img text-center">
                                    <?php echo get_field('section_4_image'); ?> 
                                </div>
                                <?php endif; ?>  
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 text-center">
                            <div class="round-picto content-picto">
                                <?php if(get_field('section_5_image')) : ?>
                                    <img src="<?php echo get_field('section_5_image')['url']; ?>" alt="plane" />
                                <?php endif; ?>  
                                <!-- img src="<?php echo get_template_directory_uri(); ?>/img/temp/solutions/picto1.png" alt="time" -->
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="content-text-round">
                                <?php the_field("section_5_texte"); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row row-percent-2">



                        <?php if( have_rows('section_6_pourcentage') ): $first_row = true; ?>
                            <?php while(have_rows('section_6_pourcentage') ): the_row(); 

                            // vars
                            $number = get_sub_field('chiffre');
                            $text = get_sub_field('texte');
                            ?>

                            <div class="col-xl-4 col-lg-6">
                                <div class="percent"><?php echo $number; ?></div>
                                <p><?php echo $text; ?></p>
                            </div>
                            <?php endwhile;  ?>
                        <?php endif; ?>
                               
                    </div>
                    <p><em><?php the_field("section_6_note"); ?></em></p>
    			</div>
    		</div>
		</section>

	</main>

<?php get_footer(); ?>
