<?php /* Template Name: Home */ 
function add_css_in_head(){
    wp_register_style('carousel', get_template_directory_uri() . '/css/owl_carousel/owl.carousel.min.css', array(), '1.0', 'all');
    wp_enqueue_style('carousel'); // Enqueue it!
    wp_register_style('carousel-theme', get_template_directory_uri() . '/css/owl_carousel/owl.theme.default.min.css', array(), '1.0', 'all');
    wp_enqueue_style('carousel-theme'); // Enqueue it! 
    wp_register_style('home', get_template_directory_uri() . '/css/home.css', array(), '1.0', 'all');
    wp_enqueue_style('home'); // Enqueue it!

    wp_register_script('carousel-script', get_template_directory_uri() . '/js/owl.carousel.min.js', '', '1.0.0'); // Custom scripts
    wp_enqueue_script('carousel-script'); // Enqueue it!
    wp_register_script('home-script', get_template_directory_uri() . '/js/home.js', '', '1.0.0'); // Custom scripts
    wp_enqueue_script('home-script'); // Enqueue it!

}
add_action('wp_head','add_css_in_head');

get_header(); ?>
	<main role="main">
    	<section id="banner" class="banner text-center" style="background: url(<?php the_post_thumbnail_url(); ?>) no-repeat center;">
            <div class="content-top-banner">
            	<div class="width-content-1580">
	    			<div class="container-fluid">
	    				<div class="row">
	    					<div class="col-lg-12">
	    						<div class="content-banner">

                                    <div class="w-100_ content-carousel">
                                        <div class="owl-carousel carousel-banner owl-theme">


                                            <?php if( have_rows('banniere_slider') ): $i=1; ?>
                                                <?php while(have_rows('banniere_slider') ): the_row(); 

                                                // vars
                                                $title = get_sub_field('titre');
                                                $content = get_sub_field('contenu');
                                                //$image = get_sub_field('icone');
                                                ?>

                                                <div class="item" data-hash="proven-<?php echo $i; ?>">
	                                                <?php //the_field("banniere_texte"); ?>
                                                    <h1><?php echo $title; ?></h1>
                                                    <div class="content-slider"><p><?php echo $content; ?></p></div>
                                                </div>

                                            <?php                                                 
                                               $i++; endwhile; 
                                            endif; ?>

                                        </div>

                                        <div class="banner-dots list-hash">
                                            <?php if( have_rows('menu_expertises') ): $i=1;?>
                                                <?php while(have_rows('menu_expertises') ): the_row(); 

                                                // vars
                                                $title = get_sub_field('titre');
                                                $link = get_sub_field('lien');
                                                $image = get_sub_field('icone');
                                                ?>
                                                <a href="<?php echo $link; ?>">
                                                    <span class="text-hash"><?php echo $title; ?></span>
                                                    <span class="ico"> <img src="<?php echo $image['url']; ?>"  alt="<?php echo $image['alt']; ?>" /></span>
                                                </a> 
                                                <?php 
                                                   $i++; endwhile; 
                                                endif; ?>
                                        </div>
                                    </div>
	    						</div>
	    					</div>
	    				</div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section-add-values">
            <div class="width-content-1580">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
    						<h2><?php the_field("added_values_titre"); ?></h2>
                            <div class="wrapper-value d-flex">
                                <div class="content-plus">
                                    <div class="img-left-s"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/plus.png" alt="plus" class=""></div>
                                </div>
                                <div class="ctt-values d-flex">
                                    <?php   
                                        $loop = new WP_Query( array( 'post_type' => 'value', 'posts_per_page' => '2' ) );
                                        if($loop){
                                            while ( $loop->have_posts() ) : $loop->the_post();
                                    ?>
                                        <div class="content-value d-flex">
                                            <div class="content-img">
                                                <img src="<?php echo get_field('image_thumbnail')['url']; ?>" alt="<?php echo get_field('image_thumbnail')['title']; ?>">
                                                <div class="bottom-value">
                                                    <div class="border-centralise"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/Centralise.png" alt="thumbs"></div>
                                                </div>
                                            </div>
                                            <div class="content-text-value">
                                                <h3><a href="<?php echo esc_url( get_page_link( 258 ) ); ?>" title=""><?php the_title(); ?></a></h3>
                                                <a href="<?php echo esc_url( get_page_link( 258 ) ); ?>"><?php the_excerpt(); ?></a>
                                            </div>
                                        </div>
                                    <?php 
                                            endwhile;
                                        }
                                        wp_reset_query();
                                    ?>


    					        </div>
                                <div class="view-all">
                                    <a href="<?php the_permalink(258); ?>" title="" class="value-view-all">VOIR TOUT</a>
                                </div>
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>


        <section class="section-case-studies">
            <div class="content-top-banner">
                <div class="width-content-1580">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-12">
                                <h2><?php the_field('case_studies_titre') ?></h2>
                            </div>
                        </div>

                        <div class="row no-gutters">
                            <div class="col-1">
                                <div class="img-left-s"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/eye-regular.svg" width="62px" alt="Testimonial" class="testimonialIcone"></div>
                            </div>
                            <div class="col-10">
                                <div class="w-100 content-carousel">
                                    <div class="owl-carousel carousel-case owl-theme" >
                                        <?php   
                                            $loop = new WP_Query( array( 'post_type' => 'studie', 'posts_per_page' => '3' ) );
                                            if($loop){ $i = 1;
                                                while ( $loop->have_posts() ) : $loop->the_post();
                                        ?>
                                            <div class="item" data-hash="studies-<?php echo $i; ?>" style="background: url(<?php echo get_field('image')['url']; ?>) no-repeat center;">
                                                <div class="content-case">
                                                  <a href="<?php echo get_permalink(74); ?>">
                                                    <div class="d-flex content-title-case">
                                                      <h3><?php the_title(); ?></h3>
                                                    <div class=logo-case><img src="<?php echo get_field('logo')['url']; ?>" alt="<?php echo get_field('image_thumbnail')['title']; ?>" /></div>
                                                    </div>
                                                    <?php the_content(); ?>
                                                  </a>
                                                </div>
                                            </div>
                                        <?php $i++;
                                                endwhile;
                                            }
                                            wp_reset_query();
                                        ?>
                                    </div>

                                    <div class="owl-dots case-hash list-hash">
                                        <?php   
                                            $loop = new WP_Query( array( 'post_type' => 'studie', 'posts_per_page' => '3' ) );
                                            if($loop){ $i = 1;
                                                while ( $loop->have_posts() ) : $loop->the_post();
                                        ?>
                                            <a class="owl-dot" href="#studies-<?php echo $i; ?>">
                                                <span class="logo-case"><img src="<?php echo get_field('logo')['url']; ?>" alt="<?php echo get_field('logo')['title']; ?>" /></span>
                                                <span class="text-hash"><?php the_title(); ?></span>
                                            </a> 

                                        <?php $i++;
                                                endwhile;
                                            }
                                            wp_reset_query();
                                        ?>
 
                                    </div>
                                </div>
                            </div>
                            <div class="col-1">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    	<section class="section-testimonial">
            <div class="width-content width-content-1580">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
                            <h2><?php the_field("testimonials_titre"); ?></h2>
                        </div>
                    </div>
                    <div class="row no-gutters">
                        <div class="col-1">
                            <div class="img-left-s"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/testimonial.png" alt="Testimonial" class="testimonialIcone"></div>
                        </div>
                        <div class="col-9">
                            <div class="container-fluid_">
                                <div class="row_ no-gutters_ owl-carousel carousel-testimonial owl-theme">
                                    <?php   
                                        $loop = new WP_Query( array( 'post_type' => 'testimonial', ) );
                                        if($loop){ $i = 1;
                                            while ( $loop->have_posts() ) : $loop->the_post();
                                    ?>
                                    <div class="item">
                                        <div class="ctt-testimonial">
                                            <div class="content-testimonial">
                                                <h3> <?php the_title(); ?></h3>
                                                <?php the_excerpt(); ?>
                                                <?php //the_content(); ?>
                                            </div>
                                            <div class="view-more"><a href="<?php the_permalink(); ?>">En savoir plus <i class="fa fa-angle-right"></i></a></div>
                                        </div>
                                    </div>
                                    <?php $i++;
                                            endwhile;
                                        }
                                        wp_reset_query();
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-1">

                        </div>
                        <div class="col-1">
                            <div class="view-all">
                                <a href="#" title="Testimonial" class="value-view-all">+</a>
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>


        <section class="section-partners">
            <div class="width-content width-content-1580">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2><?php the_field("partners_title"); ?></h2>
                        </div>
                    </div>
                    <div class="row no-gutters">

                        <div class="col-1">
                            <div class="img-left-s"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/partner.png" alt="Partner" class=""></div>
                        </div>
                        <div class="col-10">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="w-100 content-carousel">
                                            <div class="owl-carousel carousel-partners owl-theme">

                                                <?php if( have_rows('partners_list') ): ?>
                                                    <?php while(have_rows('partners_list') ): the_row(); 

                                                    // vars
                                                    $image = get_sub_field('image');
                                                    ?>

                                                    <div class="item">
                                                        <div ><img src="<?php echo $image['url']; ?>"  alt="<?php echo $image['alt']; ?>" /></div>
                                                    </div>

                                                <?php                                                 
                                                    endwhile; 
                                                endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="section-map">
            <div class="width-content width-content-1580">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2><?php the_field("implantations_title"); ?></h2>
                        </div>
                    </div>
                    <div class="row no-gutters">
                        <div class="col-1">
                            <div class="img-left-s"><img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/implantation.png" alt="Implantation" class=""></div>
                        </div>
                        <div class="col-11">
                            <div class="content-map text-center w-100">                                
                                <div class=""><img src="<?php echo get_field('implantations_image')['url']; ?>"  alt="<?php echo $image['title']; ?>" /></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section-stat">
            <div class="width-content">
                <div class="container-fluid">
                    <div class="row">
	                    <?php if( have_rows('home_stat') ):
	                    while(have_rows('home_stat') ): the_row(); ?>
                            <div class="col-lg-3">
                                <span class="number"><?php the_sub_field('number') ?></span>
                                <span class="number-desc"><?php the_sub_field('description') ?></span>
                            </div>
                        <?php
		                    endwhile;
	                    endif; ?>
                    </div>
                </div>
            </div>
        </section>
	</main>

<?php get_footer(); ?>
