<?php /* Template Name: Expertise */ 
function add_css_in_head(){
    wp_register_style('expertise', get_template_directory_uri() . '/css/expertise.css', array(), '1.0', 'all');
    wp_enqueue_style('expertise'); // Enqueue it! 
}
add_action('wp_head','add_css_in_head');
get_header(); ?>

	<main class="main-interne">
		


    	<section class="section-top">
            <div class="width-content width-content-1580">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-xl-4 offset-xl-1">
    						<h1><?php the_field("grand_titre"); ?></h1>
    					</div>
                        <div class="col-xl-7">
                            <div class="content-video">
                                <!-- img src="<?php echo get_template_directory_uri(); ?>/img/temp/solutions/play.png" alt="play" -->
                               <?php $video = get_field('video') ?>
                              <?php if (strpos($video,'iframe') !== false) {
                                the_field("video");
                              }else{
                                ?>
                              <video controls="false" autoplay muted loop style="width:100% ;">
                                <source src="<?php the_field("video"); ?>" type="video/mp4">
                                Your browser does not support the video tag.
                              </video>
                              <?php } ?>
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section__ section_1">
            <div class="width-content">
    			<div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="content-text-round">
                                <h2 id="tt"><?php the_field("section_1_titre"); ?></h2>
                                <?php the_field("section_1_texte"); ?>
                            </div>
                        </div>
                        <div class="col-lg-3 text-center">
                            <div class="round-picto content-picto">
                                <?php if(get_field('section_1_image')) : ?>
                                    <img src="<?php echo get_field('section_1_image')['url']; ?>" alt="expertise" />      
                                <?php endif; ?>  
                                <!-- img src="<?php echo get_template_directory_uri(); ?>/img/temp/solutions/picto1.png" alt="time" -->
                            </div>
                        </div>
                    </div>
                    <div class="row row-list-picto">



                        <?php if( have_rows('section_2_pictogramme_liste') ): ?>
                            <?php while(have_rows('section_2_pictogramme_liste') ): the_row(); 

                            // vars
                            $image = get_sub_field('picto');
                            $content = get_sub_field('texte');
                            ?>
                            <div class="col-lg-3">
                                <div class="item-picto">
                                    <div class="content-picto">
                                        <img src="<?php echo $image['url']; ?>" alt="time">
                                    </div>
                                    <p> <?php echo $content; ?> </p>
                                </div>
                            </div>
                            <?php endwhile;  ?>
                        <?php endif; ?>

                    </div>
    			</div>
    		</div>
		</section>

    	<section class="section__ section-bg-blue">
            <div class="width-content">
    			<div class="container-fluid">
                    <div class="row no-gutters">
                        <div class="col-lg-12 bg-blue-mba">
                            
    						<div class="container-fluid">
                        		<div class="row">
			                        <div class="col-lg-12"><h2><?php the_field("section_3_fond_bleu_titre"); ?></h2></div>
                                    <div class="col-lg-6">
			                            <div class="content-text">
                                            <?php the_field("section_3_fond_bleu_texte_gauche"); ?>
			                    		</div>
			                    	</div>
			                        <div class="col-lg-6">
			                            <div class="content-text">
                                            <?php the_field("section_3_fond_bleu_texte_droite"); ?>
			                    		</div>
			                        </div>
                                  <?php if (is_page(228)): ?>
                                    <div class="col-lg-12">
                                        <div class="content-text" style="margin-top: 30px">
                                            <?php the_field("section_3_fond_bleu_texte_bas"); ?>
                                        </div>
                                    </div>
                              <?php endif; ?>
			                    </div>
			                </div>
			            </div>
    				</div>
    			</div>
    		</div>
		</section>

	</main>

<?php get_footer(); ?>
