<?php /* Template Name: Agilité */ 
function add_css_in_head(){
    wp_register_style('agilite', get_template_directory_uri() . '/css/agilite.css', array(), '1.0', 'all');
    wp_enqueue_style('agilite'); // Enqueue it! 
}
add_action('wp_head','add_css_in_head');
get_header(); ?>

	<main class="main-interne">
		


    	<section class="section-top text-center">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
    						<h1><?php the_field('grand_titre'); ?></h1>
                            <?php the_content(); ?>
    					</div>
    				</div>
    			</div>
    		</div>
		</section>

    	<section class="section-agilite">
            <div class="width-content">
    			<div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12 text-center">
                            <div class="content-img">
                                <?php if(get_field('image_contenu')) : ?>
                                    <?php echo get_field('image_contenu'); ?>
                                <?php endif; ?>  
                            </div>
                        </div>
                    </div>
    			</div>
    		</div>
		</section>

    	<section class="section__">
            <div class="width-content width-content-1022">
    			<div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-6 text-left">
                            <div class="item-picto">
                                <?php the_field("section_1_texte_gauche"); ?>
                            </div>
                        </div>
                        <div class="col-lg-6 text-left">
                            <div class="item-picto">
                                <?php the_field("section_1_texte_droite"); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <section class="section__exp">
            <div class="width-content">
                <div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
                            <hr />
    						<div class="content_ text-center">
                                <?php the_field("section_2_paragraphe"); ?>
    						</div>
                            <hr />
    					</div>
                    </div>
    			</div>
    		</div>
		</section>

        <section class="section__">
            <div class="width-content width-content-1022">
                <div class="container-fluid">
                    <div class="row">


                        <?php if( have_rows('section_1_liste') ): ?>
                            <?php while(have_rows('section_1_liste') ): the_row(); 

                            // vars
                            $image = get_sub_field('pictogramme');
                            $content = get_sub_field('texte');
                            ?>
                            <div class="col-lg-6 col-xl-3">
                                <div class="item-picto">
                                    <div class="content-picto">
                                        <img src="<?php echo $image['url']; ?>" alt="time">
                                    </div>
                                    <p> <?php echo $content; ?> </p>
                                </div>
                            </div>
                            <?php endwhile;  ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

        <section class="section__exp">
            <div class="width-content">
                <div class="container-fluid">
    				<div class="row">
    					<div class="col-lg-12">
                            <div class="content-img text-center">

                                <?php if(get_field('section_2_image')) : ?>
                                    <img src="<?php echo get_field('section_2_image')['url']; ?>" alt="time" />      
                                <?php endif; ?>  
                            </div>
    					</div>
                    </div>
    			</div>
    		</div>
		</section>



        <section class="section__ section-bg-blue">
            <div class="width-content width-content-1022">
                <div class="container-fluid">
                    <div class="row no-gutters">
                        <div class="col-lg-12 bg-blue-mba">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="content-text">
                                            <?php the_field("section_2_texte_gauche"); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="content-text">
                                            <?php the_field("section_2_texte_droite"); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
	</main>

<?php get_footer(); ?>
