 <?php /* Template Name: Added values */ 
function add_css_in_head(){

	wp_register_style('carousel', get_template_directory_uri() . '/css/owl_carousel/owl.carousel.min.css', array(), '1.0', 'all');
	wp_enqueue_style('carousel'); // Enqueue it!

	wp_register_style('carousel-theme', get_template_directory_uri() . '/css/owl_carousel/owl.theme.default.min.css', array(), '1.0', 'all');
	wp_enqueue_style('carousel-theme'); // Enqueue it!


	wp_register_script('carousel-script', get_template_directory_uri() . '/js/owl.carousel.min.js', '', '1.0.0'); // Custom scripts
	wp_enqueue_script('carousel-script'); // Enqueue it!

	wp_register_script('value-script', get_template_directory_uri() . '/js/value.js', '', '1.0.0'); // Custom scripts
	wp_enqueue_script('value-script'); // Enqueue it!

    wp_register_style('value', get_template_directory_uri() . '/css/added_value.css', array(), '1.0', 'all');
    wp_enqueue_style('value'); // Enqueue it! 

    wp_register_style('added-list', get_template_directory_uri() . '/css/added_value_list.css', array(), '1.0', 'all');
    wp_enqueue_style('added-list'); // Enqueue it!t!
}
add_action('wp_head','add_css_in_head');

get_header(); ?>


    <main role="main" class="main-interne main-list-added-value">
        <section class="owl-carousel carousel-case owl-theme" id="valuecaroussel">
        <?php   
            $loop = new WP_Query( array(
                'post_type' => 'value',
                'posts_per_page' => -1
            ) );
            if($loop){
                 $i = 0;
                while ( $loop->have_posts() ) : $loop->the_post();
                    $i++;
        ?>

        <div class="section-top item" data-hash="studies-<?php echo $i; ?>" style="background: url(<?php the_post_thumbnail_url(); ?>) no-repeat center; background-size: cover;">
            <div class="content-top-banner">
                <div class="width-content-1580">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-10 offset-lg-1">
                                <h2 class="title-value">Added values</h2>
                                <p class="soutitre"><?php the_field("sub_title"); ?></p>
                            </div>
                            <div class="col-lg-10 offset-lg-1 withBordBot">
                                <div class="content-banner content-banner-value d-flex">
                                    <div class="content-centralise">
                                        <div class="border-centralise">
                                            <img src="<?php echo get_template_directory_uri(); ?>/img/temp/home/ico/Centralise.png" alt="thumbs">
                                        </div>
                                    </div>
                                    <div class="content-value">
                                        <h1><?php the_title(); ?></h1>
                                        <div><?php the_content(); ?></div>
                                        <div class="content-value-2"><?php the_field("content_value"); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <span class="number"><?php echo $i; ?></span>
        </div>

        <?php 
            endwhile;
            }
            wp_reset_query();
        ?>
        </section>
        <div id="list-value-bot" class="container">
             <div class="row no-gutters owl-dots case-hash list-hash">
                <?php
                    $loop = new WP_Query( array(
                        'post_type' => 'value',
                        'posts_per_page' => -1
                    ) );
                    if($loop){
                        $i = 0;
                        while ( $loop->have_posts() ) : $loop->the_post();
                            $i++;
                ?>
                    <div class="col col-list-value owl-dot">
                        <div class="content-number">
                            <a href="#studies-<?php echo $i; ?>" class="list-value d-flex">
                                <div class="number-value"><?php echo $i ?></div>
                                <div><?php the_title(); ?></div>
                            </a>
                        </div>
                    </div>
                <?php
                    endwhile;
                    }
                    wp_reset_query();
                ?>
            </div>
        </div>

    </main>
<?php get_footer(); ?>
