	<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(''); ?><?php if(wp_title('', false)) { echo ' :'; } ?> <?php bloginfo('name'); ?></title>

		<link href="//www.google-analytics.com" rel="dns-prefetch">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon.ico" rel="shortcut icon">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">

		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="<?php bloginfo('description'); ?>">

		<?php wp_head(); ?>


		<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
		<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
		<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
		<script src="https://kit.fontawesome.com/bfd4254e13.js"></script>
		<link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@1,300&family=Roboto:wght@100&family=Manrope:wght@200;300;400;500;600&display=swap" rel="stylesheet"> 
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/mba.css" />
		<script>
        // conditionizr.com
        // configure environment tests
        conditionizr.config({
            assets: '<?php echo get_template_directory_uri(); ?>',
            tests: {}
        });
        </script>

	</head>
	<body <?php body_class(); ?>>
		<!-- wrapper -->
		<div class="wrapper_">
            <div id="right-sidebar-container">
                <div class="width-content-1580">
                    <div id="right-sidebar">
                    	<div id="right-sidebar-inner">
	                        <!-- form>
	                        	<label>
		                        	<input type="radio" name="type" value="1">
		                        	<span>Quick <br/> Support</span>
		                        </label>
		                        <label>
		                        	<input type="radio" name="type" value="2">
		                        	<span>Ticket  <br/> support</span>
		                        </label>
	                        </form -->


                        	<div class="support-link">
                        		<!-- a href="https://support.mbaviation.eu/hc/en-001/restricted?return_to=https%3A%2F%2Fsupport.mbaviation.eu%2Fhc%2Fen-001" target="_blank"><span>Quick <br/> Support</span></a -->
	                        	<a href="https://support.mbaviation.eu/" target="_blank"><span>Communauté</span></a>
	                        </div>

	                        <div id="right-sidebar-bot">
	                        	<div class="socialLink"><a href="https://www.linkedin.com/company/mbaviation/" target="_blank"><span><i class="fa fa-linkedin"></i></span></a></div>
	                        	<div id="langue" class="d-none">
	                        		<a href="#">FR</a> / <a href="#">EN</a>
	                        	</div>
	                        	<div class="select-langage">

									<?php
										wp_nav_menu( array(
											'theme_location'  => 'language-menu'
										) );
									?>
								</div>
	                        </div>
	                    </div>
                    </div>
                </div>
            </div>
            <div class="wrapper_inner"><!-- /wrapper_inner -->
			<!-- header -->
			<header class="header clear" role="banner">
				<div class="width-content-1580">
					<div class="header-inner d-flex">
						<!-- logo -->
						<div class="logo">
							<a href="<?php echo home_url(); ?>">
								<!-- svg logo - toddmotto.com/mastering-svg-use-for-a-retina-web-fallbacks-with-png-script -->
								<img src="<?php echo get_template_directory_uri(); ?>/img/mbaviation.png" alt="Logo" class="logo-img">
							</a>
						</div>
						<!-- /logo -->

						<!-- nav -->
						<nav class="nav nav-right d-flex" role="navigation">
							<?php html5blank_nav(); ?>
						</nav>
						<!-- /nav -->
						<div class="d-lg-none bloc-nav-mobile">
							<button id="nav-icon1" class="nav-icon1 navbar-toggle pull-right" type="button" data-toggle="collapse" data-target="#mobile-menu"
					aria-controls="mobile-menu" aria-expanded="false" aria-label="Toggle navigation" >
							  <span></span>
							  <span></span>
							  <span></span>
							</button>
							
						</div>
					</div>
				</div>
				<div class="collapse navbar-collapse mobile-menu-home" id="mobile-menu">
					<nav>
						<?php
							wp_nav_menu( array(
								'theme_location' => 'mobile-menu'
							) );
						?>
					</nav>
				</div>

			</header>
			<!-- /header -->
